


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



matrix A=J(7,3,0)


***CHIP1988
use "E:\研究数据\CHIPS\1988\DS3：Urban Individual Data\ICPSR_09836\DS0003\09836-0003-Data.dta", clear

gen citycode=int(UCODE/100000)

gen age=V105
gen agesq=age^2
gen female=(V104==2)
gen minority=(V110==1)

keep if V111>=1 & V111<=8

recode V111 (1 2 =3) (3 4=2) (5 6 7 8=1), gen(edulevel)

gen college=(edulevel==3)

keep if V112==1  //保留就业样本

drop if V201==0
drop if V201>1500

gen lnwage=ln(V201/12)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female minority college i.citycode,r 
est sto m1 
mat A[1,1]= _b[college] 
xi: reg lnwage age agesq female minority college i.citycode if edulevel!=2,r 
mat A[1,2]= _b[college] 
xi: reg lnwage age agesq female minority college i.citycode if edulevel!=1,r 
mat A[1,3]= _b[college] 



***CHIP1995
use "E:\研究数据\CHIPS\1995\ICPSR_03012\DS0003\urbanp.dta", clear

gen citycode=int(n1/1000)

gen age=a5
gen agesq=age^2
gen female=(a4==2)
gen married=(a7==2)
gen minority=(a8==1)

keep if a11>=1 & a11<=7

recode a11 (1 2 =3) (3 4=2) (5 6 7=1), gen(edulevel)

gen college=(edulevel==3)

gen lnwage=ln(a51/12)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female minority college i.citycode,r 
est sto m1 
mat A[2,1]= _b[college] 
xi: reg lnwage age agesq female minority college i.citycode if edulevel!=2,r 
mat A[2,2]= _b[college] 
xi: reg lnwage age agesq female minority college i.citycode if edulevel!=1,r 
mat A[2,3]= _b[college] 



***CHIP2002
use "E:\研究数据\CHIPS\2002\DS0001\21741-0001-Data.dta", clear

gen citycode=int(CITY/100)

gen age=P106
gen agesq=age^2
gen female=(P105==2)
gen married=(P109==2)
gen minority=(P108!=1)
gen native=(P104==1 | P104==2)

keep if P112>=1 & P112<=9

recode P112 (1 2 3 4=1) (5 6=2) (7 8 9=3), gen(edulevel)

gen college=(edulevel==3)

gen lnwage=ln(P201/12)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female  minority college i.citycode,r 
est sto m1 
mat A[3,1]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=2,r 
mat A[3,2]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=1,r 
mat A[3,3]= _b[college] 




***CHIP2007
use "E:\研究数据\CHIPS\2007\CHIP2007_or_RUMiC2008_urban_data_20151222\UHS_w1_abc.dta", clear
gen citycode=int(count/100)

gen age=a05_1
gen agesq=age^2
gen female=(a04==2)
gen married=(a07==2 | a07==3)
gen minority=(a09!=1)
gen native=(a14==1 | a14==3)

keep if b02>=1 & b02<=9

recode b02 (1 2 3 4=1) (5 6=2) (7 8 9=3), gen(edulevel)

gen college=(edulevel==3)

gen lnwage=ln(c17)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female  minority  college i.citycode,r 
est sto m1 
mat A[4,1]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=2,r 
mat A[4,2]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=1,r 
mat A[4,3]= _b[college] 




***CHIP2013
use "E:\研究数据\CHIPS\2013\urban\CHIP2013_urban_person.dta",clear
gen citycode=int(coun/100)

gen age=a04_1
gen agesq=age^2
gen female=(a03==2)
gen married=(a05<=2)
gen minority=(a06!=1)
gen native=(a09_1<=4)

keep if a13_1>=2 & a13_1<=9

recode a13_1 (1 2 3=1) (4 5 6=2) (7 8 9=3), gen(edulevel)

gen college=(edulevel==3)

gen lnwage=ln(c05_1/12)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female  minority college i.citycode,r 
est sto m1 
mat A[5,1]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=2,r 
mat A[5,2]= _b[college] 
xi: reg lnwage age agesq female  minority college i.citycode if edulevel!=1,r 
mat A[5,3]= _b[college] 



***CHIP2018
use "E:\研究数据\CHIPS\2018\chip2018_urban_person.dta",clear

gen citycode=substr(hhcode,1,4)
destring citycode,force replace 

gen age=A04_1
gen agesq=age^2
gen female=(A03==2)
gen married=(A05<=3)
gen minority=(A06!=1)
gen native=(A09_1<=4)

keep if A13_1>=2 & A13_1<=9

recode A13_1 (1 2 3=1) (4 5 6=2) (7 8 9=3), gen(edulevel)

gen college=(edulevel==3)

gen lnwage=ln(C05_1/12)

keep lnwage age agesq female minority college citycode edulevel

xi: reg lnwage age agesq female  minority  college i.citycode,r 
est sto m1 
mat A[6,1]= _b[college] 
xi: reg lnwage age agesq female  minority  college i.citycode if edulevel!=2,r 
mat A[6,2]= _b[college] 
xi: reg lnwage age agesq female  minority  college i.citycode if edulevel!=1,r 
mat A[6,3]= _b[college] 



mat2txt,matrix(A) saving( "$DataPath\CH10\coef_chip") replace

insheet using  "$DataPath\CH10\coef_chip.txt",clear
drop if _n==7

gen index=_n
ren c1 rate_overall
ren c2 rate_highlow
ren c3 rate_highmid


save  "$DataPath\CH10\data_EduReturn_8818.dta",replace 



***读者从这里开始运行即可
use  "$DataPath\CH10\data_EduReturn_8818.dta",clear


twoway ///
(connected rate_overall index,  msize(large) msymbol(T) mcolor(gs4) lp(solid) lcolor(gs4)) ///
(connected rate_highlow index,  msize(large) msymbol(D) mcolor(gs4) lp(solid) lcolor(gs4)) ///
(connected rate_highmid index,  msize(large) msymbol(O) mcolor(gs6) lp(solid) lcolor(gs6) ) ///
,scheme(s1color)  ///
xmtick(1(1)6) xlabel(1 "1988"  2 "1995"  3 "2002"  4 "2007"  5 "2013"  6 "2018" )  ///
ymtick(0(0.2)0.8) ylabel(0(0.2)0.8, angle(360)) ///
xtitle("年份", size(med)) ytitle("", size(med)  orienta(horizontal))  ///
legend(order(1 "回报率1"  2 "回报率2"  3 "回报率3") row(1) size(medsmall)) 


graph export  "$DataPath\CH10\图_10_15_中国高等教育回报率.png", replace width(1600)