


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


***退休年龄
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="GDP per capita (current US$)" 

reshape long year,i(countryname) j(period)

ren year GDP
ren period year 
label var GDP "GDP per capita (current US$)"

keep   countryname countrycode year GDP
order  countryname countrycode year GDP

keep if year==2020

save "$DataPath\CH10\temp_GDP.dta",replace 

use "$DataPath\CH10\data_retire_age.dta",clear
replace countryname="Korea, Rep." if  countryname=="South Korea"
replace countryname="Czechia" if  countryname=="Czech Republic"
replace countryname="Viet Nam" if  countryname=="Vietnam"
replace countryname="Turkiye" if  countryname=="Turkey"
replace countryname="Slovak Republic" if  countryname=="Slovakia"
replace countryname="Russian Federation" if  countryname=="Russia"
replace countryname="Micronesia, Fed. Sts." if  countryname=="Micronesia"


merge 1:1 countryname using "$DataPath\CH10\temp_GDP.dta"

keep if _merge==3
drop _merge 

gen LnGDP=ln(GDP)
replace countryname="中国" if countryname=="China"


save "$DataPath\CH10\data_RetireAge.dta",replace 


**读者从这里开始运行即可
use "$DataPath\CH10\data_RetireAge.dta",clear
twoway ///
(scatter retire LnGDP if countryname=="中国", mcolor(gs2) msize(vlarge) msymbol(O) mlabel(countryname) mlabc(Gray2) mlabsize(large)  mlabposition(12) mlabgap(.15in))  ///
(scatter retire LnGDP if countryname!="中国", mcolor(gs8) msize(med) msymbol(Oh) mlw(med) ) ///
(lfit retire LnGDP,  lp(solid) lwidth(medthick) lco(gs4) ) ///
	   ,scale(1.0)    scheme(s1color)          ///
yline(60, lcolor(gs6) lp(dash))                                      /// 
ytitle("退休年龄", size(med))                                        ///
xtitle("Ln(人均GDP)", size(med))                                         ///
xmtick(6.5(0.50)12)  xlabel(6.5(0.50)12)                            ///
ymtick(58(2)68) ylabel(58(2)68)  ///
legend(order(1 "中国"  3 "拟合线") rows(1))                ///


graph export "$DataPath\CH10\图_10_16_退休年龄.png", replace width(1600)
