


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



***失业率1
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Unemployment, total (% of total labor force) (national estimate)" 

reshape long year,i(countryname) j(period)

ren year Unemployment1
ren period year 
label var Unemployment1 "Unemployment, total (% of total labor force) (national estimate)"

keep   countryname countrycode year Unemployment1
order  countryname countrycode year Unemployment1

save "$DataPath\CH10\temp_unemployment1.dta",replace 



***失业率2
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
keep if  dataname=="Unemployment, total (% of total labor force) (modeled ILO estimate)" 

reshape long year,i(countryname) j(period)

ren year Unemployment2
ren period year 
label var Unemployment2 "Unemployment, total (% of total labor force) (modeled ILO estimate)"

keep   countryname countrycode year Unemployment2
order  countryname countrycode year Unemployment2

save "$DataPath\CH10\temp_unemployment2.dta",replace 


merge 1:1 countrycode year using  "$DataPath\CH10\temp_unemployment1.dta"
drop _merge 

sort countryname year
save "$DataPath\CH10\data_10_1.dta",replace 




**读者从这里开始运行即可
use "$DataPath\CH10\data_10_1.dta",clear

**加拿大：Canada：：1969-2022 
**英国： United Kingdom: 1971-2022
**美国： United States: 1960-2022

keep if year>=1970 & year<=2022

twoway ///
(connected Unemployment1 year if countryname=="Canada",           msize(med) msymbol(Dh) mcolor(gs4) lp(solid) lcolor(gs4)) ///
(connected Unemployment1 year if countryname=="United Kingdom",   msize(med) msymbol(Th) mcolor(gs6) lp(solid) lcolor(gs6) ) ///
(connected Unemployment1 year if countryname=="United States",    msize(med) msymbol(Oh) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1970(2)2022)  xlabel(1970(2)2022,angle(45)) ///
ymtick(2(2)12) ylabel(2(2)12,angle(360)) ///
xtitle("年份", size(med)) ytitle("失业率(%)", size(med))  ///
legend(order(1 "加拿大"  2 "英国"  3 "美国") row(1) size(medsmall)) 

graph export "$DataPath\CH10\图_10_1_失业率_a.png", replace width(1600)



**法国：France：1970-2022
**德国：Germany：1983-2022
**意大利：Italy：1970-2022
**日本：Japan: 1960-2022

use "$DataPath\CH10\data_10_1.dta",clear

keep if year>=1970 & year<=2022

replace Unemployment1=7.5 if  countryname=="Germany" & year==1982
replace Unemployment1=5.5 if  countryname=="Germany" & year==1981
replace Unemployment1=3.8 if  countryname=="Germany" & year==1980
replace Unemployment1=3.8 if  countryname=="Germany" & year==1979
replace Unemployment1=4.3 if  countryname=="Germany" & year==1978
replace Unemployment1=4.5 if  countryname=="Germany" & year==1977
replace Unemployment1=4.6 if  countryname=="Germany" & year==1976
replace Unemployment1=4.7 if  countryname=="Germany" & year==1975
replace Unemployment1=2.6 if  countryname=="Germany" & year==1974
replace Unemployment1=1.2 if  countryname=="Germany" & year==1973
replace Unemployment1=1.1 if  countryname=="Germany" & year==1972
replace Unemployment1=0.8 if  countryname=="Germany" & year==1971
replace Unemployment1=0.7 if  countryname=="Germany" & year==1970


twoway ///
(connected Unemployment1 year if countryname=="France",   msize(med) msymbol(Dh) mcolor(gs4) lp(solid) lcolor(gs4)) ///
(connected Unemployment1 year if countryname=="Germany",  msize(med) msymbol(Th) mcolor(gs6) lp(solid) lcolor(gs6) ) ///
(connected Unemployment1 year if countryname=="Italy",    msize(med) msymbol(Oh) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment1 year if countryname=="Japan",    msize(med) msymbol(Sh) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1970(2)2022)  xlabel(1970(2)2022,angle(45)) ///
ymtick(2(2)12) ylabel(2(2)12,angle(360)) ///
xtitle("年份", size(med)) ytitle("失业率(%)", size(med))  ///
legend(order(1 "法国"  2 "德国"  3 "意大利" 4 "日本") row(1) size(medsmall)) 

graph export "$DataPath\CH10\图_10_1_失业率_b.png", replace width(1600)



*按收入划分
**High income:1990-2022
**Upper middle income: 1991-2022
**Middle income:1991-2022
**Low middle income: 1991-2022
**Low income:1991-2022

use "$DataPath\CH10\data_10_1.dta",clear

keep if year>=1990 & year<=2022
keep if countryname=="High income" | countryname=="Upper middle income" | countryname=="Middle income" | countryname=="Lower middle income" | countryname=="Low income"
twoway ///
(connected Unemployment2 year if countryname=="High income",          msize(small) msymbol(D) mcolor(gs4) lp(solid) lcolor(gs4)) ///
(connected Unemployment2 year if countryname=="Upper middle income",  msize(small) msymbol(T) mcolor(gs6) lp(solid) lcolor(gs6) ) ///
(connected Unemployment2 year if countryname=="Middle income",        msize(small) msymbol(O) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Lower middle income",  msize(small) msymbol(S) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Low income",           msize(small) msymbol(X) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1990(1)2022)  xlabel(1990(1)2022,angle(45)) ///
ymtick(3(1)8) ylabel(3(1)8,angle(360)) ///
xtitle("年份", size(med)) ytitle("失业率(%)", size(med))  ///
legend(order(1 "高收入"  2 "中高收入"  3 "中等收入" 4 "中低收入" 5 "低收入")  row(2) size(small)) 

graph export "$DataPath\CH10\图_10_1_失业率_c.png", replace width(1600)




**保加利亚：Bulgaria：1990-2022 
**捷克：Czechia：1990-2022
**匈牙利：Hungary：1990-2022
**波兰：Poland：1991-2022
**俄罗斯：Russian Federation: 1991-2022
**斯洛伐克：Slovak Republic: 1991-2022


use "$DataPath\CH10\data_10_1.dta",clear


keep if year>=1990 & year<=2022


twoway ///
(connected Unemployment1 year if countryname=="Bulgaria",           msize(small) msymbol(Dh)    mcolor(gs8) lp(solid) lcolor(gs8)) ///
(connected Unemployment1 year if countryname=="Czechia",            msize(small) msymbol(Th)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment1 year if countryname=="Hungary",            msize(small) msymbol(Oh)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment1 year if countryname=="Poland",             msize(small) msymbol(Sh)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment1 year if countryname=="Russian Federation", msize(small) msymbol(X)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment1 year if countryname=="Slovak Republic",    msize(small) msymbol(plus) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1990(1)2022)  xlabel(1990(1)2022,angle(45) labsize(small)) ///
ymtick(0(5)30) ylabel(0(5)30,angle(360)) ///
xtitle("年份", size(medsmall)) ytitle("失业率(%)", size(small))  ///
legend(order(1 "保加利亚"  2 "捷克"  3 "匈牙利" 4 "波兰" 5 "俄罗斯" 6 "斯洛伐克")  row(2) size(small)) 

graph export "$DataPath\CH10\图_10_2_失业率_6大国.png", replace width(1600)



twoway ///
(connected Unemployment2 year if countryname=="Bulgaria",           msize(small) msymbol(D)    mcolor(gs8) lp(solid) lcolor(gs8)) ///
(connected Unemployment2 year if countryname=="Czechia",            msize(small) msymbol(T)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Hungary",            msize(small) msymbol(O)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Poland",             msize(small) msymbol(S)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Russian Federation", msize(small) msymbol(X)    mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected Unemployment2 year if countryname=="Slovak Republic",    msize(small) msymbol(plus) mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1990(1)2022)  xlabel(1990(1)2022,angle(45) labsize(small)) ///
ymtick(0(5)20) ylabel(0(5)20,angle(360)) ///
xtitle("年份", size(med)) ytitle("失业率(%)", size(med))  ///
legend(order(1 "保加利亚"  2 "捷克"  3 "匈牙利" 4 "波兰" 5 "俄罗斯" 6 "斯洛伐克")  row(2) size(small)) 

graph export "$DataPath\CH10\图_10_2_失业率_6大国.png", replace width(1600)

