

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


 use "E:\研究数据\中国城市统计年鉴\city1995-2018.dta",clear
 
 keep code year 职工平均工资元_地区_元
 ren code cityid 
 replace cityid=int(cityid/100)
 bysort cityid year: egen meanwage=mean(职工平均工资元_地区_元)
 keep cityid year meanwage 
 duplicates drop cityid year,force 
 
 replace meanwage=14818.98 if cityid==4601 & year==2003
 replace meanwage=9512.98  if cityid==5204 & year==2003


 save "$DataPath\CH11\temp_avewage.dta",replace 
 
 
use "E:\研究数据\最低工资数据\minwage_1998_2018.dta",clear
 
 merge 1:1 cityid year using  "$DataPath\CH11\temp_avewage.dta"
 keep if _merge==3
 drop _merge 
 
 drop if minwage==.
 drop if meanwage==.
 
save "$DataPath\CH11\data_MW.dta",replace 


***读者从这里开始运行即可
use "$DataPath\CH11\data_MW.dta",clear

gen mwratio=minwage*12/meanwage*100

sort year

bysort year: egen mwratio_mean=mean(mwratio)
bysort year: egen mw_mean=mean(minwage)

bysort year: egen mwratio_median=median(mwratio)
bysort year: egen mw_median=median(minwage)

duplicates drop year,force 

twoway ///
(connected mwratio_mean year, msize(large) msymbol(Th) mcolor(gs4) lp(solid) lw(thin) lcolor(gs8) yaxis(1) ymtick(0(10)50, axis(1)) ylabel(0(10)50, axis(1) angle(360)) ytitle("%",axis(1) size(med) orienta(horizontal)) legend(label(1 最低工资比值) row(1) size(small) ) )  ///
(connected mw_mean year,      msize(large) msymbol(Oh) mcolor(gs4) lp(solid) lw(thin) lcolor(gs8) yaxis(2) ymtick(0(300)1500, axis(2)) ylabel(0(300)1500, axis(2) angle(360)) ytitle("元",axis(2) size(med) orienta(horizontal)) legend(label(2 最低工资) row(1) size(small) ) )  ///
,scheme(s1color)  ///
xmtick(1998(2)2018) xlabel(1998(2)2018, labsize(small) angle(30) ) xtitle("年份", size(medsmall)) 

graph export "$DataPath\CH11\图_11_5_中国最低工资_均值_比值.png", replace width(1600)





