

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



use "$DataPath\CH12\data_FDI.dta",clear

keep if 年份>=1984

gen share_fdi=实际利用外资_亿美元/GDP_亿美元*100
gen share_exp=出口总额_亿美元/GDP_亿美元*100
gen share_imp=进口总额_亿美元/GDP_亿美元*100

twoway ///
(connected share_fdi 年份, yaxis(1) ytitle("FDI(%)",axis(1) size(medsmall) ) ylabel(0(2)6,axis(1) angle(360)) msize(medsmall) msymbol(Sh) mcolor(gs8) lp(solid) lwidth(vthin)  lcolor(gs8)) ///
(connected share_exp 年份, yaxis(2) ytitle("进出口(%)",axis(2) size(medsmall) ) ylabel(5(10)35,axis(2) angle(360)) msize(medsmall) msymbol(Th) mcolor(gs8)  lp(solid) lwidth(vthin ) lcolor(gs8) ) ///
(connected share_imp 年份, yaxis(2) ytitle("进出口(%)",axis(2) size(medsmall) ) ylabel(5(10)35, axis(2) angle(360)) msize(medsmall) msymbol(Oh) mcolor(gs8)  lp(solid) lwidth(vthin) lcolor(gs8) ) ///
,scheme(s1color)   graphregion(color(white)) ///
xmtick(1984(2)2022)  xlabel(1984(2)2022,labsize(small) angle(30))  ///
xtitle("年份", size(med))   ///
legend(order(1 "FDI"  2 "出口"  3 "进口") rows(1) size(medsmall)) 

graph export "$DataPath\CH12\图_12_4_2_中国进出口的时间趋势.png", replace width(1600)

