

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


use "$DataPath\CH12\data_inequality_world.dta",clear

replace 美国2=美国2*100
replace 日本=日本*100
replace 丹麦=丹麦*100
replace 英国=英国*100
replace 法国=法国*100
replace 加拿大=加拿大*100
replace 澳大利亚=澳大利亚*100

twoway ///
(connected 美国2   年份 if 年份>=1910, msize(medsmall) msymbol(O)  mcolor(gs6) lp(solid) lw(thin) lcolor(gs6) ) ///
(connected 英国    年份 if 年份>=1910, msize(vsmall) msymbol(Dh) mcolor(gs10) lp(solid) lw(thin) lcolor(gs12) ) ///
(connected 加拿大  年份 if 年份>=1910, msize(med)  msymbol(X)  mcolor(gs10) lp(solid) lw(thin) lcolor(gs12) ) ///
(connected 法国    年份 if 年份>=1910, msize(vsmall) msymbol(Sh) mcolor(gs10) lp(solid) lw(thin) lcolor(gs12) ) ///
(connected 日本    年份 if 年份>=1910, msize(vsmall) msymbol(Th) mcolor(gs10) lp(solid) lw(thin) lcolor(gs12) ) ///
(connected 丹麦  年份 if 年份>=1910, msize(vsmall)  msymbol(Oh)  mcolor(gs10) lp(solid) lw(thin) lcolor(gs12) ) ///
,scheme(s1color)   ///
xmtick(1910(10)2010)  xlabel(1910(10)2010,labsize(small) angle(30))  ///
ymtick(2(2)12)  ylabel(2(2)12,labsize(small) angle(360))  ///
ytitle("%", orienta(horizontal) size(med)) xtitle("年份", size(medsmall))  ///
legend(order(1 "美国" 2 "英国" 3 "加拿大" 4 "法国" 5 "日本" 6 "丹麦"   )  rows(2) size(medsmall)) 

graph export "$DataPath\CH12\图_12_4_各国最富有的千分之一的人占有的收入份额.png", replace width(1600)
