


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



**出口
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
drop if _n==1


keep if  dataname=="Exports of goods and services (current US$)" 

reshape long year,i(countryname) j(period)

ren year v_export
ren period year 
label var v_export "export"


keep   countryname countrycode year v_export
order  countryname countrycode year v_export

save  "$DataPath\CH12\temp_export.dta",replace 

**进口
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
drop if _n==1


keep if  dataname=="Imports of goods and services (current US$)" 

reshape long year,i(countryname) j(period)

ren year v_import
ren period year 
label var v_import "import"


keep   countryname countrycode year v_import
order  countryname countrycode year v_import

save  "$DataPath\CH12\temp_import.dta",replace 


**GDP
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
drop if _n==1


keep if  dataname=="GDP (current US$)" 

reshape long year,i(countryname) j(period)

ren year v_GDP
ren period year 
label var v_GDP "GDP"


keep   countryname countrycode year v_GDP
order  countryname countrycode year v_GDP

save  "$DataPath\CH12\temp_GDP.dta",replace 




use  "$DataPath\CH12\temp_import.dta",clear

merge 1:1 countryname countrycode year using  "$DataPath\CH12\temp_export.dta"
drop _merge 
merge 1:1 countryname countrycode year using  "$DataPath\CH12\temp_GDP.dta"
drop _merge 

drop if v_import==. |  v_export==. |  v_GDP==.

save "$DataPath\CH12\data_Trade_GDP.dta",replace 




***读者从这里开始运行即可
use "$DataPath\CH12\data_Trade_GDP.dta",clear

bysort year: egen t_GDP=sum(v_GDP)
bysort year: egen t_import=sum(v_import)
bysort year: egen t_export=sum(v_export)
gen t_trade=t_export+t_import
gen share_trade=t_trade/t_GDP*100

duplicates drop year,force 
keep if year>=1960  & year<=2020

twoway ///
(connected share_trade year, msize(medlarge) msymbol(O)  mcolor(gs8) lp(solid) lw(thin) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1960(5)2020)  xlabel(1960(5)2020,angle(0)) ///
ymtick(20(10)60) ylabel(20(10)60,angle(360)) ///
xtitle("年份", size(med)) ytitle("(%)", size(med) orientation(horizontal))  

graph export  "$DataPath\CH12\图12_6_全球贸易_1960_2020.png", replace width(1600)
