

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



use "$DataPath\CH04\data_gdp_emp.dta",clear

tset 年份,yearly
gen emp1_lag=L.emp1
gen emp1_growth=(emp1-emp1_lag)/emp1_lag*100
gen emp2_lag=L.emp2
gen emp2_growth=(emp2-emp2_lag)/emp2_lag*100

gen GDP_growth=gdp-100

replace emp1_growth=emp2_growth if 年份>=2007  & 年份<=2010
replace emp1_growth=emp2_growth if 年份>=2017  & 年份<=2020


keep if 年份>=1978  & 年份<=2022

keep 年份 emp1_growth GDP_growth
gen raio=emp1_growth/GDP_growth

twoway ///
(bar GDP_growth  年份, fcolor(gs15) lcolor(gs8) barwidth(0.5) yaxis(1) ymtick(-2(2)16, axis(1)) ylabel(-2(2)16, axis(1) angle(360))  ytitle("%", size(med) orienta(horizontal))  legend(label(1 GDP增长率) row(1) size(small) )  ) ///
(bar emp1_growth  年份, fcolor(gs8) lcolor(gs4) barwidth(0.5) yaxis(1) ymtick(-2(2)16, axis(1)) ylabel(-2(2)16, axis(1) angle(360))  ytitle("%", size(med) orienta(horizontal))  legend(label(2 就业增长率) row(1) size(small))  ) ///
(connected raio 年份, msize(medlarge) msymbol(Th) mcolor(gs4) lp(solid) lw(thin) lcolor(gs4) yaxis(2) ymtick(-1(0.5)1, axis(2)) ylabel(-1(0.5)1, axis(2) angle(360)) ytitle("比值",axis(2) size(med)) legend(label(3 就业增长率的GDP弹性) row(1) size(small) ) )  ///
,scheme(s1color)  ///
xmtick(1978(2)2022) xlabel(1978(2)2022, labsize(small) angle(30) )  ///
xtitle("年份", size(med)) ytitle("%", size(med)  orienta(horizontal))  


graph export "$DataPath\CH04\图_4_7_中国经济增长和就业弹性.png", replace width(1600)
