



global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



**总体

use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Labor force participation rate, total (% of total population ages 15-64) (modeled ILO estimate)" 

reshape long year,i(countryname) j(period)

ren year lfp_total
ren period year 
label var lfp_total "Labor force participation rate, total (% of total population ages 15-64) (modeled ILO estimate)"

keep   countryname countrycode year lfp_total
order  countryname countrycode year lfp_total

save "$DataPath\CH05\temp_lfp_total.dta",replace 


**男性
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Labor force participation rate, male (% of male population ages 15-64) (modeled ILO estimate)" 

reshape long year,i(countryname) j(period)

ren year lfp_male
ren period year 
label var lfp_male "Labor force participation rate, male (% of male population ages 15-64) (modeled ILO estimate)"

keep   countryname countrycode year lfp_male
order  countryname countrycode year lfp_male

save "$DataPath\CH05\temp_lfp_male.dta",replace 


**女性
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Labor force participation rate, female (% of female population ages 15-64) (modeled ILO estimate)" 

reshape long year,i(countryname) j(period)

ren year lfp_female
ren period year 
label var lfp_female "Labor force participation rate, female (% of female population ages 15-64) (modeled ILO estimate)"

keep   countryname countrycode year lfp_female
order  countryname countrycode year lfp_female

save "$DataPath\CH05\temp_lfp_female.dta",replace 




use "$DataPath\CH05\temp_lfp_total.dta",clear

merge 1:1 countryname countrycode year using "$DataPath\CH05\temp_lfp_male.dta"
keep if _merge==3
drop _merge 

merge 1:1 countryname countrycode year using "$DataPath\CH05\temp_lfp_female.dta"
keep if _merge==3
drop _merge 

keep if countryname=="China"

save "$DataPath\CH05\data_lfp_China.dta",replace 

erase "$DataPath\CH05\temp_lfp_total.dta"
erase "$DataPath\CH05\temp_lfp_male.dta"
erase "$DataPath\CH05\temp_lfp_female.dta"




**读者从这里运行即可
use "$DataPath\CH05\data_lfp_China.dta",clear

keep if year>=1990

twoway ///
(connect lfp_total year   , msize(medlarge) msymbol(Oh) mcolor(gs6) lp(solid) lcolor(gs8) ) ///
(connect lfp_male year   , msize(med) msymbol(Th) mcolor(gs6) lp(solid) lcolor(gs8) ) ///
(connect lfp_female year  , msize(medlarge) msymbol(Sh) mcolor(gs6) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)  ///
xmtick(1990(2)2022)  xlabel(1990(2)2022,labsize(small) angle(30))  ///
ymtick(70(5)90) ylabel(70(5)90, angle(360)) ///
xtitle("年份", size(medsmall))  ytitle("%",  size(med) orienta(horizontal)) ///
legend(order(1 "总体" 2 "男性" 3 "女性" ) row(1) size(medsmall)) 

graph export "$DataPath\CH05\图_5_12_中国城镇劳动力参与率.png", replace width(1600)


