

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



**利用原始数据提取所需变量
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="GDP per capita (current US$)" 

reshape long year,i(countryname) j(period)

ren year gdp
ren period year 
label var gdp "GDP per capita (current US$)"

keep   countryname countrycode year gdp
order  countryname countrycode year gdp 

save "$DataPath\CH05\temp_gdp.dta",replace 





use "$DataPath\CH05\data_workingtime.dta",clear


ren entity countryname
ren averageannualworkinghoursperwork workingtime

gen country=(countryname=="Australia")
replace country=2 if countryname=="Canada"
replace country=3 if countryname=="China"
replace country=4 if countryname=="France"
replace country=5 if countryname=="Germany"
replace country=6 if countryname=="India"
replace country=7 if countryname=="Indonesia"
replace country=8 if countryname=="Japan"
replace country=9 if countryname=="Korea, Rep."
replace country=10 if countryname=="Malaysia"
replace country=11 if countryname=="Pakistan"
replace country=12 if countryname=="Philippines"
replace country=13 if countryname=="Russian Federation"
replace country=14 if countryname=="Singapore"
replace country=15 if countryname=="United Kingdom"
replace country=16 if countryname=="United States"


*keep if country>=1 & country<=16
keep if year>=1950


merge 1:1 countryname year using "$DataPath\CH05\temp_gdp.dta"

keep if _merge==3
drop _merge 

keep if year==2015

save "$DataPath\CH05\data_5_8.dta",replace 


erase "$DataPath\CH05\temp_gdp.dta"



***读者可以从这里开始运行

use "$DataPath\CH05\data_5_8.dta",clear

gen gdp1=gdp/10000


twoway ///
  (scatter  workingtime gdp1 if year==2015,mcolor(gs8) msize(large) msymbol(Oh))    ///
  ( lfit    workingtime gdp1 if year==2015,clwidth(med) lw(med) lpattern(solid) lcolor(gs4)) ///
   ,legend(off)    scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
xtitle("人均GDP(万美元)", size(med))               ///
ytitle("年份", size(small)) ytitle("年均工作时间(小时)", size(small))  ///
xmtick(0(4)12)  xlabel(0(4)12, labsize(med) angle(0))   ///
ymtick(1400(200)2400) ylabel(1400(200)2400, labsize(small) angle(360)) ///
text(2 20 "trainin=34.28+.00032 *gdp;  {it:R}{sup:2} =0.15", size(small))     


graph export "$DataPath\CH05\图_5_8_国家发展水平和工作时间.png", replace width(1600)


