

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"




***国家的时间趋势图

use "$DataPath\CH05\data_workingtime.dta",clear


ren entity countryname
ren averageannualworkinghoursperwork workingtime

gen country=(countryname=="Australia")
replace country=2 if countryname=="Canada"
replace country=3 if countryname=="China"
replace country=4 if countryname=="France"
replace country=5 if countryname=="Germany"
replace country=6 if countryname=="India"
replace country=7 if countryname=="Indonesia"
replace country=8 if countryname=="Japan"
replace country=9 if countryname=="Korea, Rep."
replace country=10 if countryname=="Malaysia"
replace country=11 if countryname=="Pakistan"
replace country=12 if countryname=="Philippines"
replace country=13 if countryname=="Russian Federation"
replace country=14 if countryname=="Singapore"
replace country=15 if countryname=="United Kingdom"
replace country=16 if countryname=="United States"




*keep if country>=1 & country<=16
keep if year>=1950
replace countryname="澳大利亚" if countryname=="Australia"  
replace countryname="加拿大" if countryname=="Canada" 
replace countryname="中国" if countryname=="China" 
replace countryname="法国" if countryname=="France" 
replace countryname="德国" if countryname=="Germany"  
replace countryname="印度" if countryname=="India" 
replace countryname="印度尼西亚" if countryname=="Indonesia" 
replace countryname="日本" if countryname=="Japan" 
replace countryname="韩国" if countryname=="Korea, Rep." 
replace countryname="马拉西亚" if countryname=="Malaysia" 
replace countryname="巴基斯坦" if countryname=="Pakistan" 
replace countryname="菲律宾" if countryname=="Philippines" 
replace countryname="俄罗斯" if countryname=="Russian Federation" 
replace countryname="新加坡" if countryname=="Singapore" 
replace countryname="英国"  if countryname=="United Kingdom"
replace countryname="美国"  if countryname=="United States"
replace countryname="瑞典"  if countryname=="Sweden"


twoway ///
(connected workingtime year if countryname=="德国",    msize(small) msymbol(Sh) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected workingtime year if countryname=="法国",    msize(med) msymbol(+)    lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected workingtime year if countryname=="英国",    msize(med) msymbol(X)    lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected workingtime year if countryname=="瑞典",    msize(small) msymbol(Oh) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8))  ///
(connected workingtime year if countryname=="新加坡",  msize(small) msymbol(Dh) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8))  ///
(connected workingtime year if countryname=="美国",    msize(small) msymbol(Th) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1950(10)2020)  xlabel(1950(10)2020, labsize(small) angle(0))  ///
ymtick(1400(200)2400) ylabel(1400(200)2400, labsize(small) angle(360)) ///
xtitle("年份", size(small)) ytitle("年均工作时间(小时)", size(small))  ///
legend(order(  1 "德国" 2 "法国" 3 "英国"  4 "瑞典" 5 "新加坡" 6 "美国"  )  row(1) size(small)) 



**额外的一张图
graph export  "$DataPath\CH05\图_5_9_平均劳动时间.png", replace width(1600)



twoway ///
(connected workingtime year if countryname=="新加坡",  msize(small) msymbol(Dh) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8))  ///
(connected workingtime year if countryname=="中国",    msize(small) msymbol(Th) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected workingtime year if countryname=="日本",    msize(small) msymbol(Sh) lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
(connected workingtime year if countryname=="印度",    msize(med) msymbol(+)    lw(thin)  mcolor(gs8) lp(solid) lcolor(gs8) ) ///
,scheme(s1color)   ///
xmtick(1950(10)2020)  xlabel(1950(10)2020, labsize(small) angle(0))  ///
ymtick(1800(200)2400) ylabel(1800(200)2400, labsize(small) angle(360)) ///
xtitle("年份", size(small)) ytitle("年均工作时间(小时)", size(small))  ///
legend(order(  1  "新加坡" 2 "中国"  3 "日本"  4 "印度")  row(2) size(small)) 

graph export  "$DataPath\CH05\图_5_9_平均劳动时间_亚洲.png", replace width(1600)


