



global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



**======图6.1=========

use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Government expenditure on education, total (% of GDP)" 

reshape long year,i(countryname) j(period)

ren year Share_EduExp
ren period year 
label var Share_EduExp "Government expenditure on education, total (% of GDP)"

keep   countryname countrycode year Share_EduExp
order  countryname countrycode year Share_EduExp

save "$DataPath\CH06\temp_EduExp.dta",replace 







**读者从这里运行即可


****教育支出_分国家组别

use "$DataPath\CH06\temp_EduExp.dta",clear

gen country=(countryname=="Low income")
replace country=2 if countryname=="Lower middle income"
replace country=3 if countryname=="Middle income"
replace country=4 if countryname=="Upper middle income"
replace country=5 if countryname=="High income"

keep if country>=1 & country<=5

replace Share_EduExp=2.843825 if countryname=="Low income" &  year==2005

gen yearindex=(year==2000)
replace yearindex=2 if year==2005
replace yearindex=3 if year==2010
replace yearindex=4 if year==2015 
replace yearindex=5 if year==2020


keep if yearindex>=1 & yearindex<=5 

keep countryname country yearindex Share_EduExp

replace Share_EduExp=Share_EduExp-mod(Share_EduExp,0.01)

save "$DataPath\CH06\temp_EduExp_Group.dta",replace 

forvalues i=1/5{
    use "$DataPath\CH06\temp_EduExp_Group.dta",clear
	keep if country==`i'
	keep yearindex Share_EduExp
	ren Share_EduExp Share_EduExp`i'
	save "$DataPath\CH06\temp_EduExp_Group`i'.dta",replace
}

use  "$DataPath\CH06\temp_EduExp_Group1.dta",clear
forvalues i=2/5{
merge 1:1 yearindex using "$DataPath\CH06\temp_EduExp_Group`i'.dta"
drop _merge
}
order yearindex 

twoway ///
(connected Share_EduExp1 yearindex, msize(large) msymbol(X) mcolor(gs6) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Share_EduExp2 yearindex, msize(med)   msymbol(T) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Share_EduExp3 yearindex, msize(med)   msymbol(O) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Share_EduExp4 yearindex, msize(med)   msymbol(S) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Share_EduExp5 yearindex, msize(med)   msymbol(D) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
,scheme(s1color)  graphregion(color(white))   ///
xmtick(1(1)5)  xlabel(1 "2000"  2 "2005"  3 "2010"  4 "2015"  5 "2020"  )  ///
ymtick(2.5(0.5)5) ylabel(2.5(0.5)5, angle(360)) ///
xtitle("年份", size(medsmall)) ytitle("(%)", size(medsmall) orienta(horizontal))  ///
legend(order(1 "低收入国家"  2 "中低收入国家" 3 "中等收入国家" 4 "中高收入国家" 5 "高收入国家" ) row(2) size(small)) 


graph export "$DataPath\CH06\图_6_1_不同收入组别国家的公共教育经费占GDP比重.png", replace width(1600)


earse "$DataPath\CH06\temp_EduExp_Group1.dta"
earse "$DataPath\CH06\temp_EduExp_Group2.dta"
earse "$DataPath\CH06\temp_EduExp_Group3.dta"
earse "$DataPath\CH06\temp_EduExp_Group4.dta"
earse "$DataPath\CH06\temp_EduExp_Group5.dta"



