

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



***CHIP2018
use "E:\研究数据\CHIPS\2018\chip2018_urban_person.dta",clear

gen citycode=substr(hhcode,1,4)
destring citycode,force replace 

gen age=2018-A04_1
gen agesq=age^2
gen female=(A03==2)
gen married=(A05<=3)
gen minority=(A06!=1)
gen native=(A09_1<=4)

keep if A13_1>=2 & A13_1<=9
keep if A13_3>=0 & A13_3<=21

recode A13_1 (1 2 3=1) (4 5 6=2) (7 =3) ( 8 9=4), gen(edulevel)
gen edu=1 
replace edu=2 if  A13_3==12
replace edu=3 if  A13_3>=13 & A13_3<=15
replace edu=4 if  A13_3>=16
gen income=C05_1

keep if age>=18 & age<75

gen agegroup=1
replace agegroup=2 if age>=25 & age<35
replace agegroup=3 if age>=35 & age<45
replace agegroup=4 if age>=45 & age<55
replace agegroup=5 if age>=55 & age<65
replace agegroup=6 if age>=65  

keep income edu agegroup
drop if income<500
bysort edu agegroup: egen Income=mean(income)
drop income 
replace Income=Income/10000

duplicates drop edu agegroup,force 

save "$DataPath\CH06\temp_Income.dta",replace 







**读者从这里运行即可


forvalues i=1/4{
    use "$DataPath\CH06\temp_Income.dta",clear
	keep if edu==`i'
	keep Income  agegroup
	ren Income Income`i'
	save "$DataPath\CH06\temp_Income`i'.dta",replace
}

use  "$DataPath\CH06\temp_Income1.dta",clear
forvalues i=2/4{
merge 1:1 agegroup using "$DataPath\CH06\temp_Income`i'.dta"
drop _merge
}
order agegroup 
twoway ///
(connected Income1 agegroup, msize(med) msymbol(D) mcolor(gs6) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Income2 agegroup, msize(med)   msymbol(S) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Income3 agegroup, msize(med)   msymbol(T) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
(connected Income4 agegroup, msize(med)   msymbol(O) mcolor(gs8) lp(solid)  lwidth(medthin) lcolor(gs8)) ///
,scheme(s1color)  graphregion(color(white))   ///
xmtick(1(1)6)  xlabel(1 "<25"  2 "[25,35)"  3 "[35,45)"  4 "[45,55)"  5 "[55,65)" 6 ">=65",angle(15) )  ///
ymtick(2(2)12) ylabel(2(2)12, angle(360)) ///
xtitle("岁", size(med) ) ytitle("(万元)", size(medsmall) orienta(horizontal))  ///
legend(order(1 "<12"  2 "12" 3 "[13-15]" 4 ">=16" ) row(1) size(small)) 


graph export "$DataPath\CH06\图_6_2_中国城镇男性的年龄收入曲线_分教育年限.png", replace width(1600)


