

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



***图6.7

use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Firms offering formal training (% of firms)" 

reshape long year,i(countryname) j(period)

ren year firm_training 
ren period year 
label var firm_training  "Firms offering formal training (% of firms)"

keep   countryname countrycode year firm_training 
order  countryname countrycode year firm_training 

save "$DataPath\CH06\temp_training.dta",replace 



use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="GDP per capita (current US$)" 

reshape long year,i(countryname) j(period)

ren year gdp
ren period year 
label var gdp "GDP per capita (current US$)"

keep   countryname countrycode year gdp
order  countryname countrycode year gdp 

save "$DataPath\CH06\temp_gdp.dta",replace 



**读者从这里开始运行即可

use "$DataPath\CH06\temp_training.dta",clear

merge 1:1  countryname countrycode year using "$DataPath\CH06\temp_gdp.dta"
keep if _merge==3
drop _merge 

drop if gdp==.
drop if firm_training==.

gen gdp1=gdp/10000

save "$DataPath\CH06\data_training.dta",replace 



**读者从这里开始运行即可

use "$DataPath\CH06\data_training.dta",clear

twoway ///
  (scatter  firm_training gdp1,mcolor(gs8) msize(large) msymbol(Oh))    ///
  ( lfit    firm_training gdp1,clwidth(med) lw(medthick) lpattern(solid) lcolor(gs4)) ///
   ,legend(off)    scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
ytitle("提供培训的企业比例 (%)", size(med))                                        ///
xtitle("人均GDP(万美元)", size(med))               ///
xmtick(0(2)12)  xlabel(0(2)12, labsize(med) angle(0))   ///
ymtick(0(20)100) ylabel(0(20)100,labsize(med) angle(360)) ///
text(2 20 "trainin=34.28+.00032 *gdp;  {it:R}{sup:2} =0.15", size(small))     

graph export "$DataPath\CH06\图_6_7_发展水平和培训供给.png", replace width(1600)


**进行等分
xtile quati=gdp,nq(100)
bysort quati: egen gdp_quati=mean(gdp)
bysort quati: egen training_quati=mean(firm_training)

twoway ///
  (scatter  training_quati gdp_quati,mcolor(gs8) msize(large) msymbol(Oh))    ///
  ( lfit    training_quati gdp_quati,clwidth(med) lw(medthick) lpattern(solid) lcolor(gs4)) ///
   ,legend(off)    scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
ytitle("Firms offering formal training (% of firms)", size(med))                                        ///
xtitle("GDP per capita (current US$)", size(med))               ///
xmtick(0(20000)80000)  xlabel(0(20000)80000, labsize(med) angle(0))   ///
ymtick(10(10)60) ylabel(10(10)60,labsize(med) angle(360)) ///
text(20 200000 "trainin=34.28+.00032 *gdp;  {it:R}{sup:2} =0.15", size(small))     

graph export "$DataPath\CH06\图_6_7_发展水平和培训供给_等分.png", replace width(1600)


