


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


use "$DataPath\CH06\temp_86_09.dta",clear

matrix A=J(24,3,0)
gen index=year-1985
gen Lnwage=ln(wage)
drop if wage==0
forvalues i=1/24{
xi: reg Lnwage female age age_2 eduyear  occu i.provcode if index==`i',r
mat A[`i',1]=_b[female]
mat A[`i',2]=_b[eduyear]
  }
  
mat2txt,matrix(A) saving("$DataPath\CH06\coef_edureturn.txt") replace



insheet using "$DataPath\CH06\coef_edureturn.txt",clear
gen year=1985+_n
ren c2 edureturn 
keep year edureturn
replace edureturn=edureturn*100

merge 1:1 year using "$DataPath\CH06\data_edu_return.dta"
drop _merge

merge 1:1 year using "$DataPath\CH06\data_num_graduate.dta"
drop _merge

save "$DataPath\CH06\data_edu_return_num.dta",replace 




**读者从这里开始运行即可

use "$DataPath\CH06\data_edu_return_num.dta",clear 
keep if year<=2020

sort year 


twoway ///
(connected fleisherandwang2005 year,  msize(small) msymbol(Sh) mcolor(gs8) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("教育回报率(%)",axis(1) size(small) )) ///
(connected zhangetal2005       year,  msize(small) msymbol(Th)  mcolor(gs8) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("教育回报率(%)",axis(1) size(small) )) ///
(connected edureturn           year,  msize(med) msymbol(Oh)  mcolor(gs6) lp(solid) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("教育回报率(%)",axis(1) size(small) )) ///
(connected 本专科              year,  msize(small) msymbol(Dh)  mcolor(gs6) lp(solid) lcolor(gs8) lw(thin) yaxis(2) ymtick(0(200)1000, axis(2)) ylabel(0(200)1000,  axis(2) angle(360))  ytitle("大学生数量(万人)",axis(2) size(small) ) ) ///
,scheme(s1color)  ///
xmtick(1975(5)2020) xlabel(1975(5)2020, angle(0)) xtitle("年份", size(medsmall))   ///
legend(order(1 "Fleisher and Wang (2005)"  2 "Zhang et al. (2005)"    3  "作者自算" 4 "大学生数量") row(2) size(small)) 

graph export "$DataPath\CH06\图_6_8_教育回报率的长期变动趋势.png", replace width(1600)


**更多教育回报率的版本
twoway ///
(connected fleisherandwang2005 year,  msize(med) msymbol(Sh) mcolor(gs8) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("%",axis(1) size(medsmall)orienta(horizontal) )) ///
(connected liandding2002       year,  msize(med) msymbol(+) mcolor(gs6) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("%",axis(1) size(medsmall) )) ///
(connected zhangetal2005       year,  msize(med) msymbol(Th)  mcolor(gs8) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("%",axis(1) size(medsmall) )) ///
(connected gaoandsymth2012     year,  msize(med) msymbol(Dh) mcolor(gs6) lp(shortdash) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("%",axis(1) size(medsmall) )) ///
(connected edureturn           year,  msize(med) msymbol(Oh)  mcolor(gs6) lp(solid) lcolor(gs8) lw(thin) yaxis(1) ymtick(-2(4)14, axis(1)) ylabel(-2(4)14, axis(1) angle(360)) ytitle("%",axis(1) size(medsmall) )) ///
(connected 本专科              year,  msize(med) msymbol(X)  mcolor(gs6) lp(solid) lcolor(gs8) lw(thin) yaxis(2) ymtick(0(200)1000, axis(2)) ylabel(0(200)1000,  axis(2) angle(360))  ytitle("大学生数量(万人)",axis(2) size(medsmall) ) ) ///
,scheme(s1color)  ///
xmtick(1975(5)2020) xlabel(1975(5)2020, angle(0)) xtitle("年份", size(med))   ///
legend(order(1 "Fleisher and Wang (2005)" 2 "Li and Ding (2002)" 3 "Zhang et al. (2005)"  4  "Gao and Symth (2012)"  5  "作者自算" 6 "大学生数量") row(2) size(small)) 

graph export "$DataPath\CH06\图_6_8_教育回报率的长期变动趋势_v2.png", replace width(1600)



