

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



**======表6.1=========

use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear

keep if  dataname=="Government expenditure on education, total (% of GDP)" 

reshape long year,i(countryname) j(period)

ren year Share_EduExp
ren period year 
label var Share_EduExp "Government expenditure on education, total (% of GDP)"

keep   countryname countrycode year Share_EduExp
order  countryname countrycode year Share_EduExp

save "$DataPath\CH06\temp_EduExp.dta",replace 



**读者从这里运行即可


**========国家==================
**澳大利亚：Australia: 2000-2005-2010-2015-2020
**加拿大：Canada: 2000-2005-2010-2015-2020
**中国：China:1999-2005-2010-2015-2020
**法国：France: 2000-2005-2010-2015-2020
**德国：Germany: 2000-2005-2010-2015-2020 
**印度：India: 2000-2005-2010-2015-2020
**印度尼西亚：Indonesia: 2001-2005-2010-2015-2020
**日本：Japan: 2000-2005-2010-2015-2020
**韩国：Korea, Rep.: 1999-----2010-2015-2018
**马拉西亚：Malaysia: 2000-2006-2010-2015-2020
**巴基斯坦：Pakistan: 2000-2005-2010-2015-2020
**菲律宾：Philippines: 2000-2005-2010-2015-2020
**俄罗斯：Russian Federation: 2000-2005-2010-2015-2020
**新加坡：Singapore: 2000-2005-2010-2015-2020
**英国： United Kingdom: 2000-2005-2010-2015-2020 
**美国： United States: 2000-2005-2010-2015-2020 

**可以考虑其他国家： 
**阿根廷：Argentina: 2000-2005-2010-2015-2020 
**波兰：Poland: 2000-2005-2010-2015-2020
**葡萄牙：Portugal：2000-2005-2010-2015-2020
**西班牙：Spain：2000-2005-2010-2015-2020
**南非：South Asia：2000-2005-2010-2015-2020

use "$DataPath\CH06\temp_EduExp.dta",clear


gen country=0
replace country=1 if countryname=="United Kingdom"
replace country=2 if countryname=="France"
replace country=3 if countryname=="Germany"
replace country=4 if countryname=="United States"
replace country=5 if countryname=="Australia" 
replace country=6 if countryname=="Canada"
replace country=7 if countryname=="Korea, Rep."
replace country=8 if countryname=="Japan"
replace country=9 if countryname=="Singapore"
replace country=10 if countryname=="Malaysia"
replace country=11 if countryname=="China"
replace country=12 if countryname=="Indonesia"
replace country=13 if countryname=="Russian Federation"
replace country=14 if countryname=="Pakistan"
replace country=15 if countryname=="Philippines"
replace country=16 if countryname=="India"
replace country=17 if countryname=="Uganda"

replace Share_EduExp=1.88804 if year==1999 & countryname=="China"
replace Share_EduExp=2.39    if year==2005 & countryname=="China"

gen yearindex=(year==2000)
replace yearindex=2 if year==2005
replace yearindex=3 if year==2010
replace yearindex=4 if year==2015 
replace yearindex=5 if year==2020

replace yearindex=. if year==2000 & countryname=="Indonesia"
replace yearindex=1 if year==2001 & countryname=="Indonesia"

replace yearindex=. if year==2000 & countryname=="Korea, Rep."
replace yearindex=1 if year==1999 & countryname=="Korea, Rep."

replace yearindex=. if year==2000 & countryname=="China"
replace yearindex=1 if year==1999 & countryname=="China"

replace yearindex=. if year==2005 & countryname=="Malaysia"
replace yearindex=2 if year==2006 & countryname=="Malaysia"

replace yearindex=. if year==2010 & countryname=="Philippines"
replace yearindex=3 if year==2009 & countryname=="Philippines"

replace yearindex=. if year==2005 & countryname=="Uganda"
replace yearindex=2 if year==2004 & countryname=="Uganda"


replace yearindex=. if year==2005 & countryname=="Niger"
replace yearindex=2 if year==2006 & countryname=="Niger"

keep if country>=1 & country<=19
keep if yearindex>=1 & yearindex<=5 

keep countryname country yearindex Share_EduExp

replace Share_EduExp=Share_EduExp-mod(Share_EduExp,0.01)

reshape wide Share_EduExp,i(countryname) j(yearindex)

order country countryname Share_EduExp1 Share_EduExp2 Share_EduExp3 Share_EduExp4 Share_EduExp5

lab var  Share_EduExp1  "2000年"
lab var  Share_EduExp2  "2005年"
lab var  Share_EduExp3  "2010年"
lab var  Share_EduExp4  "2015年"
lab var  Share_EduExp5  "2020年"

replace countryname="澳大利亚" if countryname=="Australia"  
replace countryname="加拿大" if countryname=="Canada" 
replace countryname="中国" if countryname=="China" 
replace countryname="法国" if countryname=="France" 
replace countryname="德国" if countryname=="Germany"  
replace countryname="印度" if countryname=="India" 
replace countryname="印度尼西亚" if countryname=="Indonesia" 
replace countryname="日本" if countryname=="Japan" 
replace countryname="韩国" if countryname=="Korea, Rep." 
replace countryname="马拉西亚" if countryname=="Malaysia" 
replace countryname="巴基斯坦" if countryname=="Pakistan" 
replace countryname="菲律宾" if countryname=="Philippines" 
replace countryname="俄罗斯" if countryname=="Russian Federation" 
replace countryname="新加坡" if countryname=="Singapore" 
replace countryname="英国"  if countryname=="United Kingdom"
replace countryname="美国"  if countryname=="United States"
replace countryname="埃塞俄比亚"  if countryname=="Ethiopia"
replace countryname="乌干达"  if countryname=="Uganda"
replace countryname="尼日尔"  if countryname=="Niger"

sort country 
drop country 

outsheet using "$DataPath\CH06\temp_EduExp_6_1.xls",replace 
outsheet using "$DataPath\CH06\temp_EduExp_6_1.txt",replace 




**补充数据的
**补充了中国1999和2005年的数据
use "E:\研究数据\跨国数据\data_worldpop_2022.dta",clear
ren var1 countryname 
ren var2 countrycode
ren var3 dataname 
ren var4 datacode 

ren 	var5	 year1960
ren 	var6	 year1961
ren 	var7	 year1962
ren 	var8	 year1963
ren 	var9	 year1964
ren 	var10	 year1965
ren 	var11	 year1966
ren 	var12	 year1967
ren 	var13	 year1968
ren 	var14	 year1969
ren 	var15	 year1970
ren 	var16	 year1971
ren 	var17	 year1972
ren 	var18	 year1973
ren 	var19	 year1974
ren 	var20	 year1975
ren 	var21	 year1976
ren 	var22	 year1977
ren 	var23	 year1978
ren 	var24	 year1979
ren 	var25	 year1980
ren 	var26	 year1981
ren 	var27	 year1982
ren 	var28	 year1983
ren 	var29	 year1984
ren 	var30	 year1985
ren 	var31	 year1986
ren 	var32	 year1987
ren 	var33	 year1988
ren 	var34	 year1989
ren 	var35	 year1990
ren 	var36	 year1991
ren 	var37	 year1992
ren 	var38	 year1993
ren 	var39	 year1994
ren 	var40	 year1995
ren 	var41	 year1996
ren 	var42	 year1997
ren 	var43	 year1998
ren 	var44	 year1999
ren 	var45	 year2000
ren 	var46	 year2001
ren 	var47	 year2002
ren 	var48	 year2003
ren 	var49	 year2004
ren 	var50	 year2005
ren 	var51	 year2006
ren 	var52	 year2007
ren 	var53	 year2008
ren 	var54	 year2009
ren 	var55	 year2010
ren 	var56	 year2011
ren 	var57	 year2012
ren 	var58	 year2013
ren 	var59	 year2014
ren 	var60	 year2015
ren 	var61	 year2016
ren 	var62	 year2017
ren 	var63	 year2018
ren 	var65	 year2020
ren 	var66	 year2021
ren 	var67	 year2022

keep if  dataname=="Government expenditure on education, total (% of GDP)" 

reshape long year,i(countryname) j(period)

ren year Share_EduExp
ren period year 
label var Share_EduExp "Government expenditure on education, total (% of GDP)"

keep   countryname countrycode year Share_EduExp
order  countryname countrycode year Share_EduExp

save "$DataPath\CH06\temp_EduExp1.dta",replace 