

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



***表格6.2

***利用Barro-Lee Data
***网址：http://barrolee.com/?p=103
***Barro-Lee Estimates of Educational Attainment for the Population Aged 15-64 from 1950 to 2015
***以下程序利用了Education Attainment for Population Aged 25-64（Total Population）的数据

use "$DataPath\CH06\BL_v3_MF2564.dta",clear

gen countryindex=(country=="USA")
replace countryindex=2  if country=="United Kingdom"
replace countryindex=3  if country=="Germany"
replace countryindex=4  if country=="France"
replace countryindex=5  if country=="Japan"
replace countryindex=6  if country=="Republic of Korea"
replace countryindex=7  if country=="Russian Federation"
replace countryindex=8  if country=="India"
replace countryindex=9  if country=="Brazil"
replace countryindex=10 if country=="South Africa"
replace countryindex=11 if country=="China"

keep if countryindex>=1 & countryindex<=11


gen yearindex=(year==1950)
replace yearindex=2  if year==1960
replace yearindex=3  if year==1970
replace yearindex=4  if year==1980
replace yearindex=5  if year==1990
replace yearindex=6  if year==2000 
replace yearindex=7  if year==2010
replace yearindex=8  if year==2015

keep if yearindex>=1 & yearindex<=8

sort country year 


keep country yearindex yr_sch


reshape wide yr_sch,i(country) j(yearindex)

gen countryindex=(country=="USA")
replace countryindex=2  if country=="United Kingdom"
replace countryindex=3  if country=="Germany"
replace countryindex=4  if country=="France"
replace countryindex=5  if country=="Japan"
replace countryindex=6  if country=="Republic of Korea"
replace countryindex=7  if country=="Russian Federation"
replace countryindex=8  if country=="India"
replace countryindex=9  if country=="Brazil"
replace countryindex=10 if country=="South Africa"
replace countryindex=11 if country=="China"

sort countryindex 

gen countryname=""
replace countryname="美国"  if country=="USA"
replace countryname="英国"  if country=="United Kingdom"
replace countryname="德国" if country=="Germany" 
replace countryname="法国" if country=="France" 
replace countryname="日本" if country=="Japan" 
replace countryname="韩国" if country=="Republic of Korea"
replace countryname="俄罗斯" if country=="Russian Federation" 
replace countryname="印度" if country=="India" 
replace countryname="巴西" if country=="Brazil" 
replace countryname="南非" if country=="South Africa" 
replace countryname="中国" if country=="China" 

order country countryname

drop countryindex 

ren yr_sch1 year_1950
ren yr_sch2 year_1960
ren yr_sch3 year_1970
ren yr_sch4 year_1980
ren yr_sch5 year_1990
ren yr_sch6 year_2000
ren yr_sch7 year_2010
ren yr_sch8 year_2015

outsheet using "$DataPath\CH06\temp_EduExp_6_2_BarroLeeData.xls",replace 
outsheet using "$DataPath\CH06\temp_EduExp_6_2_BarroLeeData.txt",replace 




***利用Human Development Data:1970-2024
***!!!!数据缺失很严重

insheet using "$DataPath\CH06\WB_EDSTATS_UIS_EA_MEAN_1T6.csv",clear

keep if sex_label=="Total"
order ref_area ref_area_label indicator_label time_period obs_value
keep  ref_area ref_area_label indicator_label time_period obs_value 

ren time_period year 
ren ref_area countrycode
ren ref_area_label countryname
ren obs_value  MeanEduYear 

keep   countryname countrycode year MeanEduYear
order  countryname countrycode year MeanEduYear

label var MeanEduYear "UIS: Mean years of schooling (ISCED 1 or higher), population 25+ years, both sexes"

save "$DataPath\CH06\temp_MeanEduYear.dta",replace 


**读者从这里运行即可

use "$DataPath\CH06\temp_MeanEduYear.dta",clear


**========国家==================
**美国： United States:       1970--80--90--??--10--20:     00用2004年插补
**英国： United Kingdom:      19??--??--??--??--10--20:     70年用71年插补；其他不好插补
**德国：Germany:              19??--??--??--??--10--20:     00用2004年插补； 其他都不好插补
**法国：France:               19??--??--90--??--10--??:     00用2004年插补；20年可以用19年插补
**日本：Japan:                1970--80--90--??--10--20:     00不好插补
**韩国：Korea, Rep.:          1970--80--90--00--10--??:     20年用15年插补
**俄罗斯：Russian Federation: 1970--??--??--??--10--??:     90年用89年插补， 00年用02年插补，20年用21年插补
**印度：India:                19??--??--??--??--??--20:     70年用71年插补，80年用81年插补；10年用11年插补
**巴西：Brazil：              1970--80--??--??--10--??:     00用04年插补; 20可用18年插补
**南非：South Africa：        1970--80--??--??--10--20:
**中国：China：               19??--??--90--00--10--20:


gen country=(countryname=="United States")
replace country=2 if countryname=="United Kingdom"
replace country=3 if countryname=="Germany"
replace country=4 if countryname=="France"
replace country=5 if countryname=="Japan"
replace country=6 if countryname=="Korea, Rep."
replace country=7 if countryname=="Russian Federation"
replace country=8 if countryname=="India"
replace country=9 if countryname=="Brazil"
replace country=10 if countryname=="South Africa"
replace country=11 if countryname=="China"

keep if country>=1 & country<=11


gen yearindex=(year==1960)
replace yearindex=2  if year==1970
replace yearindex=3  if year==1980
replace yearindex=4  if year==1990
replace yearindex=5  if year==2000 
replace yearindex=6  if year==2010
replace yearindex=7  if year==2020

sort country year 


sort country yearindex 


keep if yearindex>=1 & yearindex<=7 



replace MeanEduYear=12.82 if year==2000 & countryname=="United States"

replace MeanEduYear=11.37 if year==1970 & countryname=="United Kingdom"

replace MeanEduYear=13.80 if year==2000 & countryname=="Germany"

replace MeanEduYear=10.24 if year==2000 & countryname=="France"
replace MeanEduYear=11.61 if year==2020 & countryname=="France"

replace MeanEduYear=12.12 if year==2020 & countryname=="Korea, Rep."

replace MeanEduYear=7.54 if year==1990 & countryname=="Russian Federation"
replace MeanEduYear=12.18 if year==2000 & countryname=="Russian Federation"
replace MeanEduYear=12.41 if year==2020 & countryname=="Russian Federation"

replace MeanEduYear=1.29  if year==1970 & countryname=="India"
replace MeanEduYear=2.18  if year==1980 & countryname=="India"
replace MeanEduYear=5.30  if year==2010 & countryname=="India"

replace MeanEduYear=5.98  if year==2000 & countryname=="Brazil"
replace MeanEduYear=7.98  if year==2020 & countryname=="Brazil"

replace MeanEduYear=7.46 if year==2000 & countryname=="South Africa"

replace MeanEduYear=3.97  if year==1980 & countryname=="China"

sort country year


keep countryname country yearindex MeanEduYear



reshape wide MeanEduYear,i(countryname) j(yearindex)

order country countryname  MeanEduYear2 MeanEduYear3 MeanEduYear4 MeanEduYear5 MeanEduYear6 MeanEduYear7
 
replace countryname="美国"  if countryname=="United States"
replace countryname="英国"  if countryname=="United Kingdom"
replace countryname="德国" if countryname=="Germany" 
replace countryname="法国" if countryname=="France" 
replace countryname="日本" if countryname=="Japan" 
replace countryname="韩国" if countryname=="Korea, Rep."
replace countryname="俄罗斯" if countryname=="Russian Federation" 
replace countryname="印度" if countryname=="India" 
replace countryname="巴西" if countryname=="Brazil" 
replace countryname="南非" if countryname=="South Africa" 
replace countryname="中国" if countryname=="China" 

*drop countryname   

sort country

outsheet using "$DataPath\CH06\temp_EduExp_6_2.xls",replace 
outsheet using "$DataPath\CH06\temp_EduExp_6_2.txt",replace 






