

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"




***========表格6.3================

use "$DataPath\CH06\data_EduProfile_Census2020.dta",clear
 
gen share_1=(未上过学+学前教育)/总数*100
gen share_2=(小学+初中)/总数*100
gen share_3=高中/总数*100
gen share_4=(大学专科+大学本科+硕士研究生+博士研究生)/总数*100
 
keep 年龄 share_1 share_2 share_3 share_4 
 
replace share_1=round(share_1, .01)
replace share_2=round(share_2, .01)
replace share_3=round(share_3, .01)
replace share_4=round(share_4, .01)

drop if _n>=10

lab var 年龄 "年龄"
lab var share_1 "未上学"
lab var share_2 "初中及以下"
lab var share_3 "高中"
lab var share_4 "大学及以上"

outsheet using  "$DataPath\CH06\temp_Edu_6_4.xls",replace 
outsheet using  "$DataPath\CH06\temp_Edu_6_4.txt",replace 







***其他年份

***计算2010和2020年人口普查的学历结构
**25岁以上人口
**
use "$DataPath\CH06\data_EduProfile_Census2000.dta",clear
drop if _n==1

egen T_all=sum(总数)
egen T_1=sum(未上过学+扫盲班)
egen T_2=sum(小学+初中)
egen T_3=sum(高中+中专)
egen T_4=sum(大学专科+大学本科+研究生)

gen share_1=T_1/T_all*100
gen share_2=T_2/T_all*100
gen share_3=T_3/T_all*100
gen share_4=T_4/T_all*100

egen NT_1=sum(小学)
egen NT_2=sum(初中)
egen NT_3=sum(高中+中专)
egen NT_4=sum(大学专科+大学本科+研究生)

gen AveEdu=(NT_1*6+NT_2*9+NT_3*12+NT_4*16)/T_all

keep if _n==1
keep share_1 share_2 share_3 share_4  AveEdu 
gen year=2000
save "$DataPath\CH06\temp_Census2000.dta",replace 
 
 
 
use "$DataPath\CH06\data_EduProfile_Census2010.dta",clear
drop if _n==1

egen T_all=sum(总数)
egen T_1=sum(未上过学)
egen T_2=sum(小学+初中)
egen T_3=sum(高中)
egen T_4=sum(大学专科+大学本科+研究生)

gen share_1=T_1/T_all*100
gen share_2=T_2/T_all*100
gen share_3=T_3/T_all*100
gen share_4=T_4/T_all*100

egen NT_1=sum(小学)
egen NT_2=sum(初中)
egen NT_3=sum(高中)
egen NT_4=sum(大学专科+大学本科+研究生)

gen AveEdu=(NT_1*6+NT_2*9+NT_3*12+NT_4*16)/T_all

keep if _n==1
keep share_1 share_2 share_3 share_4  AveEdu 
gen year=2010
save "$DataPath\CH06\temp_Census2010.dta",replace 
 

 
use "$DataPath\CH06\data_EduProfile_Census2020.dta",clear
drop if _n==1

egen T_all=sum(总数)
egen T_1=sum(未上过学+学前教育)
egen T_2=sum(小学+初中)
egen T_3=sum(高中)
egen T_4=sum(大学专科+大学本科+硕士研究生+博士研究生)

gen share_1=T_1/T_all*100
gen share_2=T_2/T_all*100
gen share_3=T_3/T_all*100
gen share_4=T_4/T_all*100

egen NT_1=sum(小学)
egen NT_2=sum(初中)
egen NT_3=sum(高中)
egen NT_4=sum(大学专科+大学本科+硕士研究生+博士研究生)

gen AveEdu=(NT_1*6+NT_2*9+NT_3*12+NT_4*16)/T_all


keep if _n==1
keep share_1 share_2 share_3 share_4  AveEdu
gen year=2020
save "$DataPath\CH06\temp_Census2020.dta",replace 

append using "$DataPath\CH06\temp_Census2010.dta"
append using "$DataPath\CH06\temp_Census2000.dta"
order year
sort year

save "$DataPath\CH06\data_EduProfile_Census_0020.dta",replace 



