


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


**原始数据
use "E:\研究数据\CHIPS\2007\CHIP2007_or_RUMiC2008_urban_data_20151222\UHS_w1_abc.dta", clear
gen citycode=int(count/100)

gen age=a05_1
gen agesq=age^2
gen female=(a04==2)
gen married=(a07==2 | a07==3)
gen minority=(a09!=1)
gen native=(a14==1 | a14==3)

**教育程度代码: 1.未上过学 2.扫盲班 3.小学 4.初中 5.高中 6.中专 7.大学专科 8.大学本科 9.研究生
keep if b02>=1 & b02<=9

gen skilled=(b02>=7)

**b10: 除正规学校教育外，您是否接受过任何培训?
*①没有参加任何培训(跳到下一人或下一表) ②农业生产培训 ③企业内部的非农业培训 ④社会上的非农业培训 ⑤其他培训,请说明
gen train_yes=(b10!=1)
gen train_yes_firm=(b10==3 | b10==23 | b10==34 | b10==35 | b10==43 | b10==234 | b10==345 | b10==435)
bysort skilled: tab train_yes
bysort skilled: tab train_yes_firm

**b11.(问B10≠1)您最近一次接受的是什么类型的培训?
**①与工作相关的技能培训 ②与工作无关的一般技能培训 ③一般性培训,如维护工人权益等 ④其他,请说明
keep if b10!=1
drop if b11==4
gen train_general=(b11!=1)

tab train_general
bysort skilled: tab train_general

*b12: (问B10≠1)这次培训一共多少天(不足一天按一天计算)?

*b13:(问B10≠1)这次培训总共花了多少钱?(元，包括本人支付和他人支付,没缴费者请填0)

**b14:谁支付这次培训的费用? 
**①政府有关部门 ②自费 ③现在的雇主 ④以前的雇主 ⑤本人与雇主分担 ⑥其他
drop if b14==6

gen feeindex=1 
replace feeindex=2  if b14==5
replace feeindex=3  if b14==3 | b14==4
replace feeindex=4  if b14==1

bysort train_general: tab b14
bysort train_general: tab feeindex


keep feeindex train_general 
replace train_general=train_general+1

forvalues i=1/4{
	gen fee`i'=(feeindex==`i')
}

save  "$DataPath\CH06\data_trainfee.dta",replace 






 ***读者从这里运行即可
 **如果发现mat2txt无法使用，建议先ssc install mat2txt,然后再运行

 matrix A=J(4,2,0)
 
 forvalues i=1/2{
     forvalues j=1/4{
    use "$DataPath\CH06\data_trainfee.dta",clear
	collapse (mean) temp=fee`j' if train_general==`i' , fast
    mat A[`j',`i']= temp[1]  
 }
 }
 
 mat2txt,matrix(A) saving( "$DataPath\CH07\temp_6_5.txt") replace
 
 insheet using  "$DataPath\CH07\temp_6_5.txt",clear

 
  forvalues i=1/2{
	replace c`i'=c`i'*100  
   replace c`i'= round(c`i', 0.01)
}


 keep v1 c1 c2 
 order v1 c1 c2 
 
 lab var c1 "特殊培训"
 lab var c2 "一般培训"
 
 replace v1="自费"           if _n==1
 replace v1="本人与雇主承担" if _n==2
 replace v1="雇主承担"       if _n==3
 replace v1="政府承担"       if _n==4
 
 outsheet using "$DataPath\CH06\表_6_5_培训经费承担比例.xls",replace 
 outsheet using "$DataPath\CH06\表_6_5_培训经费承担比例.txt",replace 






