

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



***CHIP1995
 use "E:\研究数据\CHIPS\1995\ICPSR_03012\DS0003\urbanp.dta",clear
 
 keep if a23>=0 & a23<=40
 ren a23 duration
 gen period=1
 replace period=2 if duration>5 & duration<=10
 replace period=3 if duration>10 & duration<=25
 replace period=4 if duration>25
 
 
 gen year=1995 
 keep year period 
 save "$DataPath\CH07\chip_95.dta",replace 
 
 
 
***CHIP2002
 use "E:\研究数据\CHIPS\2002\DS0001\21741-0001-Data.dta",clear
 
 keep if P132A>=0 & P132A<=40
 ren P132A duration
 gen period=1
 replace period=2 if duration>5 & duration<=10
 replace period=3 if duration>10 & duration<=25
 replace period=4 if duration>25
 
 
 gen year=2002 
 keep year period 
 save "$DataPath\CH07\chip_02.dta",replace 
 
 
**CHIP2007
use "E:\研究数据\CHIPS\2007\CHIP2007_or_RUMiC2008_urban_data_20151222\UHS_w1_abc.dta",clear

 keep if  c10_1>=1967 & c10_1<=2007
 
 
 gen duration=2007-c10_1
 gen period=1
 replace period=2 if duration>5 & duration<=10
 replace period=3 if duration>10 & duration<=25
 replace period=4 if duration>25
 
 
 drop year
 gen year=2007 
 keep year period 
 save "$DataPath\CH07\chip_07.dta",replace 
 
 

**CHIP2013
use "E:\研究数据\CHIPS\2013\urban\CHIP2013_urban_person.dta", clear
 
 keep if c02>=1973 & c02<=2013
 
 
 gen duration=2013-c02
 gen period=1
 replace period=2 if duration>5 & duration<=10
 replace period=3 if duration>10 & duration<=25
 replace period=4 if duration>25
 
 gen year=2013 
 keep year period 
 save "$DataPath\CH07\chip_13.dta",replace 
 


**CHIP2018
 use "E:\研究数据\CHIPS\2018\chip2018_urban_person.dta",clear
 
 keep if C02>=1978 & C02<=2018
 
 
 gen duration=2018-C02
 gen period=1
 replace period=2 if duration>5 & duration<=10
 replace period=3 if duration>10 & duration<=25
 replace period=4 if duration>25
 
 gen year=2018 
 keep year period 
 save "$DataPath\CH07\chip_18.dta",replace 
 
 

 use "$DataPath\CH07\chip_95.dta",clear
 
 append using "$DataPath\CH07\chip_02.dta"
 append using "$DataPath\CH07\chip_07.dta"
 append using "$DataPath\CH07\chip_13.dta"
 append using "$DataPath\CH07\chip_18.dta"
 
 
save "$DataPath\CH07\data_chip_9518.dta",replace
 
erase "$DataPath\CH07\chip_95.dta" 
erase "$DataPath\CH07\chip_02.dta"
erase "$DataPath\CH07\chip_07.dta"
erase "$DataPath\CH07\chip_13.dta"
erase "$DataPath\CH07\chip_18.dta"
 
 
 
**读者从这里开始运行即可
**如果发现mat2txt无法使用，建议先ssc install mat2txt,然后再运行

 matrix A=J(5,4,0)
 
 forvalues i=1/5{
 	  forvalues j=1/4{
	  	 use "$DataPath\CH07\data_chip_9518.dta",clear
 
 bysort year: tab period
 
 gen period_1=(period==1)
 gen period_2=(period==2)
 gen period_3=(period==3)
 gen period_4=(period==4)

 
 gen yearindex=1 
 replace yearindex=2  if year==2002 
 replace yearindex=3  if year==2007
 replace yearindex=4  if year==2013 
 replace yearindex=5  if year==2018 
	  	collapse (mean) temp =period_`j' if yearindex==`i', fast
        mat A[`i',`j']= temp[1]  
	  }
 }


 mat2txt,matrix(A) saving( "$DataPath\CH07\mean_chip.txt") replace

insheet using  "$DataPath\CH07\mean_chip.txt",clear

gen year=1995 if _n==1
replace year=2002  if _n==2
replace year=2007  if _n==3
replace year=2013  if _n==4
replace year=2018  if _n==5

keep year c1 c2 c3 c4 
order year 


lab var  c1 "0-5年"
lab var  c2 "6-10年"
lab var  c3 "11-25年"
lab var  c4 "26-40年"

forvalues i=1/4{
	replace c`i'=c`i'*100  
   replace c`i'= round(c`i', 0.1)
}

ren c1 c_0_5
ren c2 c_6_10
ren c3 c_11_25 
ren c4 c_26_40

**直接从stata数据中复制也行
outsheet using "$DataPath\CH07\表_7_1_中国员工的工作稳定性.xls",replace 

erase  "$DataPath\CH07\mean_chip.txt"
