
global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"




***NOTE：本程序是教材8.2.2小节的数据描述【教材第174页】


use "E:\研究数据\CLDS\2016年\CLDS2016individual_171106.dta",clear

gen cityid=int(CID2016/100)
gen provid=int(cityid/100)
replace cityid=provid*100 if provid==11 | provid==12 | provid==31 |  provid==50

drop if birthyear==.  //删除出生年份缺失的样本
drop if I2_14_psu==. //删除出生地信息缺失的样本
drop if I2_16_psu==.  //删除14岁时出生地省份/自治区/直辖市编码缺失的样本
drop if I2_1==.   //删除教育信息缺失的样本

gen age_2016=2016-birthyear       //年龄
gen agesq_2016=age_2016^2         //年龄平方

gen female=(gender==2)            //性别，女性=1
gen married=(marriage==2 | marriage==3)   //已婚=1
gen urbanhukou=(I1_14>1)  //非农或居民户口

ren I2_14_psu place_birth //出生地信息
gen place_birth_city=int(place_birth/100)
gen place_birth_pro=int(place_birth_city/100)

replace place_birth_city=place_birth_pro*100 if place_birth_pro==11|place_birth_pro==12|place_birth_pro==31|place_birth_pro==50

gen place_age14=I2_16_psu          //14岁时出生地省份/自治区/直辖市编码
gen place_age14_city=int(place_age14/100)
gen place_age14_pro=int(place_age14_city/100)
replace place_age14_city=place_age14_pro*100 if place_age14_pro==11|place_age14_pro==12|place_age14_pro==31|place_age14_pro==50

gen cityid_hk=int(I1_3_1_psu/100)
gen provid_hk=int(cityid_hk/100)
replace cityid_hk=provid_hk*100 if provid_hk==11 | provid_hk==12 | provid_hk==31 |  provid_hk==50


ren I1_3_3 num_brothers //兄弟姐妹数量
rename I1_8 foreignlanguage       //是否懂外语
rename I1_13 hukou_birth          //出生时的户口类型
rename I1_14 hukou_current        //目前的户口类型
rename I1_14_1 urbanhukou_getyear //非农或居民户口的获取时间
rename I2_1 education             //最高学历
rename I2_1_2 education_endyear   //最高学历毕业年份

gen edu_high=(education>=8)   //高技能组别，大专及以上


ren I3_4_w16 housework_yes 
replace housework_yes=0 if housework_yes==2 //是否做过家务,有=1
ren I3_4_1_w16 housework_time //家务劳动平均每天花费多少分钟

replace housework_yes=0 if housework_time<10      //家务劳动小于10分钟，认为是没有做过家务
drop if housework_yes==1 & housework_time==99997  //删除做过家务但家务时间异常的样本
drop if housework_yes==1 & housework_time==99998
drop if housework_yes==1 & housework_time==99999

gen emp_1=(work2015==1)  //2017年1月以来是否工作过,工作过=1
gen emp_2=(I3a_7_0==1)   //您现在的工作情况:1 有工作 ； 2 无工作
ren I3a_6  income   //总收入
ren I3a_6_1  wage   //总工资

ren occupation occu
ren I3a_8 indu
ren I3a_9 workunit //单位类型
ren I3a_16 jobtype //工作类型为雇员，雇主，自雇和务农四种

*以下的事情在多大程度上由自己来决定的？
gen flex_1=I3a_20_1_w16  //工作任务的内容
gen flex_2=I3a_20_2_w16  //工作进度的安排
gen flex_3=I3a_20_3_w16  //工作量/工作强度
 
ren I3a_25_w16 jobyear //目前或最近这份工作开始的年份
ren I3a_2 worktime_hour  //您过去一周工作几小时？
ren I3a_5 worktime_month //您过去一年工作几个月？



replace emp_2=0 if worktime_hour==99997 | worktime_hour==99998 | worktime_hour==99999
replace emp_2=0 if worktime_month==99997 | worktime_month==99998 | worktime_month==99999

ren I3a_5_1 commute_time  //每天上班和下班在路途上要花费的时间(分钟)
ren I3a_5_3 commute_fee  //工作日一般每天上班和下班所花的路费


**户口迁移情况
ren I1_16 migHK_index //户口是否迁移
ren I1_16_1 migHK_times //户口迁移次数

rename I1_17_1_1_1_  migHK_1time    //第1次户口迁移的年份
rename I1_17_1_1_2_  migHK_2time    //第2次户口迁移的年份
rename I1_17_1_1_3_  migHK_3time    //第3次户口迁移的年份
rename I1_17_1_1_4_  migHK_4time    //第4次户口迁移的年份
rename I1_17_1_1_5_  migHK_5time    //第5次户口迁移的年份


rename I1_17_1_2_1_  migHKReason_1time    //第1次户口迁移的原因
rename I1_17_1_2_2_  migHKReason_2time    //第2次户口迁移的原因
rename I1_17_1_2_3_  migHKReason_3time    //第3次户口迁移的原因
rename I1_17_1_2_4_  migHKReason_4time    //第4次户口迁移的原因
rename I1_17_1_2_5_  migHKReason_5time    //第5次户口迁移的原因


**流动经历
rename I2_16_0 migration     //14岁是否有跨县市迁移经历
rename I2_16_1 migration_indentify  //14岁是否有跨县市迁移经历

rename I2_16_5_1_ migration_2time   //是否有第2次迁移
rename I2_16_5_2_ migration_3time   //是否有第3次迁移
rename I2_16_5_3_ migration_4time   //是否有第4次迁移
rename I2_16_5_4_ migration_5time   //是否有第5次迁移
rename I2_16_5_5_ migration_6time   //是否有第6次迁移
rename I2_16_5_6_ migration_7time   //是否有第7次迁移
rename I2_16_5_7_ migration_8time   //是否有第8次迁移
rename I2_16_5_8_ migration_9time   //是否有第9次迁移
rename I2_16_5_9_ migration_10time  //是否有第10次迁移

replace migration=0 if migration==2 
forvalues i=2/10{
replace migration_`i'time=0 if migration_`i'time==2 | migration_`i'time==.
}
gen migration_times=migration
forvalues i=2/10{
replace migration_times= migration_times+migration_`i'time
}

gen migration_index=(migration_times>0)

gen mig_index1=(cityid_hk!=cityid)
gen mig_index2=(I1_3_2==4)
keep if I1_3_2>=1 & I1_3_2<=4

**没有工作的经历?

drop if I4c_1_w16>18

keep if age_2016>=18  & age_2016<=60

keep I1_3_2 I4c_1_w16 female edu_high migration_index mig_index1 mig_index2 married  
save "$DataPath\CH08\data_CLDS2016.dta",replace 






**读者从这里开始运行即可

use "$DataPath\CH08\data_CLDS2016.dta",clear

gen x=(I4c_1_w16>0) //无工作经历次数

bysort female: summ x

bysort edu_high: summ x

bysort migration_index: summ x

bysort mig_index1: summ x
bysort mig_index2: summ x

keep if female==1

bysort married: summ x


gen native=(I1_3_2!=4)
bysort native: summ x