

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"




use "$DataPath\CH08\data_figure_8_13.dta",clear

replace 出国留学人员=出国留学人员/10000
replace 学成回国留学人员=学成回国留学人员/10000

keep if 年份>=1978

gen ratio=学成回国留学人员/出国留学人员

twoway ///
(connected 出国留学人员     年份, msize(med) msymbol(O) mcolor(gs8) lp(shortdash) lcolor(gs10) yaxis(1) ytitle("万人", axis(1) size(med))  ) ///
(connected 学成回国留学人员 年份, msize(med) msymbol(T) mcolor(gs8) lp(shortdash) lcolor(gs10) yaxis(1) ytitle("万人", axis(1) size(med))  ) ///
(line ratio                 年份, lwidth(thick) lp(solid) lcolor(gs4) yaxis(2) ytitle("比例",axis(2) size(med)) ) ///
,scheme(s1color)   ///
xmtick(1978(2)2020)  xlabel(1978(2)2020,labsize(small) angle(30))  ///
xtitle("年份", size(med))  ///
legend(order(1 "出国留学人员" 2 "学成回国人员" 3 "回国人员占比")  rows(1) size(medsmall)) 

graph export "$DataPath\CH08\图_8_13_中国出国留学与留学归国人数统计.png", replace width(1600)

