


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


use "E:\研究数据\历年人口普查数据\2010\中国2010年人口普查分县资料\excel\4.dta",clear

merge m:1 cityname1 using "E:\研究数据\中国城市统计年鉴\cityname_stata14.dta"

keep if _merge==3
drop _merge 

gen pop_low=male_edu0+female_edu0+male_priamry+female_primary+male_middle+famale_middle+male_highschool+female_highschool 
gen pop_high=male_college+female_college+male_university+female_university

gen share_high=pop_high/(pop_low+pop_high)*100

keep cityid share_high cityname1

save "$DataPath\CH09\temp_skill_2010.dta",replace 


use "E:\研究数据\历年人口普查数据\按2010年市代码匹配的数据\82new_stata14.dta", clear

ren citygb10 cityid
replace cityid=1100 if provgb10==11
replace cityid=1200 if provgb10==12
replace cityid=3100 if provgb10==31
replace cityid=5000 if provgb10==50

gen  pop_c=p82001/10000
replace p82011=p82011*pop_c
bysort cityid: egen num_high=sum(p82011)
bysort cityid: egen num_total=sum(p82001)
gen share_high_82=num_high/num_total*100
keep share_high_82  cityid

duplicates drop cityid,force 

save "$DataPath\CH09\temp_skill_1982.dta",replace 



use "$DataPath\CH09\temp_skill_1982.dta",clear
merge 1:1 cityid using "$DataPath\CH09\temp_skill_2010.dta"
keep if _merge==3
drop _merge 

save "$DataPath\CH09\Skill_1982_2010.dta",replace 


**读者从这里开始运行即可
use "$DataPath\CH09\Skill_1982_2010.dta",clear

gen share_delta=share_high-share_high_82

twoway ///
  (scatter  share_delta share_high_82,mcolor(gs6) msize(med) msymbol(Oh) mlabel(cityname1) mlabc(Gray2) mlabsize(small))    ///
  ( lfit    share_delta share_high_82,clwidth(med) lpattern(solid) lcolor(gs6)) ///
   ,legend(off)    scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
ytitle("比重增量", size(med))                                        ///
xtitle("1982年大学生比重(%)", size(med))               ///
xmtick(0(1)4)  xlabel(0(1)4, labsize(med) angle(0))   ///
ymtick(0(10)40) ylabel(0(10)40,labsize(med) angle(360)) ///
text(5 2.75 "比重增量=4.2+9.7*1982年大学生比重;  {it:R}{sup:2} =0.73", size(small))     

graph export "$DataPath\CH09\图9_5_大学生集聚.png", replace width(1600)
