


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


***美国省份层面人口和GDP：2020
use "$DataPath\CH09\US_GDP_POP.dta",clear

egen gdp_total=sum(gdp)
egen pop_total=sum(pop)

gen gdp_share=gdp/gdp_total*100
gen pop_share=pop/pop_total*100

gen gdp_sharenew=1/gdp_share
sort gdp_sharenew

gen provindex=_n

twoway ///
  (bar     gdp_share provindex,  fcolor(gs6) lcolor(gs6) scheme(s1color)  barwidth(0.5) fintensity(inten10))    ///
  (line pop_share provindex, lp(solid) lcolor(gs4) )    ///
   ,legend(order(1 "占全美GDP占比" 2 "占全美人口占比" ) row(1) size(small)) ///
   xtitle("", size(med)) ytitle("%", size(med)  orienta(horizontal))  ///
ymtick(0(2)14) ylabel(0(2)14, angle(0))  ///
xmtick(1(1)51) ///
xlabel( ///
1	"加利福尼亚州" ///
2	"得克萨斯州" ///
3	"纽约州" ///
4	"佛罗里达州" ///
5	"伊利诺伊州" ///
6	"宾夕法尼亚州" ///
7	"俄亥俄州" ///
8	"佐治亚州" ///
9	"新泽西州" ///
10	"华盛顿州" ///
11	"北卡罗来纳州" ///
12	"马萨诸塞州" ///
13	"弗吉尼亚州" ///
14	"密歇根州" ///
15	"马里兰州" ///
16	"科罗拉多州" ///
17	"田纳西州" ///
18	"亚利桑那州" ///
19	"明尼苏达州" ///
20	"印第安纳州" ///
21	"威斯康星州" ///
22	"密苏里州" ///
23	"康涅狄格州" ///
24	"俄勒冈州" ///
25	"南卡罗来纳州" ///
26	"路易斯安那州" ///
27	"亚拉巴马州" ///
28	"肯塔基州" ///
29	"犹他州" ///
30	"艾奥瓦州" ///
31	"俄克拉荷马州" ///
32	"堪萨斯州" ///
33	"内华达州" ///
34	"华盛顿特区" ///
35	"阿肯色州" ///
36	"内布拉斯加州" ///
37	"密西西比州" ///
38	"新墨西哥州" ///
39	"新罕布什尔州" ///
40	"爱达荷州" ///
41	"夏威夷州" ///
42	"特拉华州" ///
43	"西弗吉尼亚州" ///
44	"缅因州" ///
45	"罗得岛州" ///
46	"南达科他州" ///
47	"北达科他州" ///
48	"蒙大纳州" ///
49	"阿拉斯加州" ///
50	"怀俄明州" ///
51	"佛蒙特州" , angle(90) labsize(vsmall))

graph export "$DataPath\CH09\图_课后习题10_美国GDPPOP.png", replace width(1600)



***中国省份层面人口和GDP：2023
use "$DataPath\CH09\data_ProvGDP_Pop.dta",clear

egen gdp_total=sum(gdp)
egen pop_total=sum(pop)

gen gdp_share=gdp/gdp_total*100
gen pop_share=pop/pop_total*100

gen gdp_sharenew=1/gdp_share
sort gdp_sharenew

gen provindex=_n

twoway ///
  (bar     gdp_share provindex,  fcolor(gs6) lcolor(gs6) scheme(s1color)  barwidth(0.5) fintensity(inten10))    ///
  (line pop_share provindex, lp(solid) lcolor(gs4) )    ///
   ,legend(order(1 "GDP占比" 2 "人口占比" ) row(1) size(small)) ///
   xtitle("", size(med)) ytitle("%", size(med)  orienta(horizontal))  ///
ymtick(0(2)10) ylabel(0(2)10, angle(0))  ///
xmtick(1(1)31)  ///
xlabel( ///
1	"广东" ///
2	"江苏" ///
3	"山东" ///
4	"浙江" ///
5	"四川" ///
6	"河南" ///
7	"湖北" ///
8	"福建" ///
9	"湖南" ///
10	"上海" ///
11	"安徽" ///
12	"河北" ///
13	"北京" ///
14	"陕西" ///
15	"江西" ///
16	"辽宁" ///
17	"重庆" ///
18	"云南" ///
19	"广西" ///
20	"山西" ///
21	"内蒙古" ///
22	"贵州" ///
23	"新疆" ///
24	"天津" ///
25	"黑龙江" ///
26	"吉林" ///
27	"甘肃" ///
28	"海南" ///
29	"宁夏" ///
30	"青海" ///
31	"西藏" , angle(30) labsize(vsmall))


graph export "$DataPath\CH09\图_课后习题10_中国GDPPOP.png", replace width(1600)

