


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



use "$DataPath\CH09\data_mig_crossprov.dta",clear

gen num_outmig=北京+天津+河北+山西+内蒙古+辽宁+吉林+黑龙江+上海+江苏+浙江+安徽+福建+江西+山东+河南+湖北+湖南+广东+广西+海南+重庆+四川+贵州+云南+西藏+陕西+甘肃+青海+宁夏+新疆

replace num_outmig=num_outmig*10/10000
egen outmig_total=sum(num_outmig)

gen share_outmig=num_outmig/outmig_total*100

order num_outmig share_outmig outmig_total

keep num_outmig share_outmig outmig_total


replace num_outmig=round(num_outmig, .01)
replace share_outmig=round(share_outmig, .01)

outsheet using "$DataPath\CH09\表_9_1_中国各省人口流出规模.xls",replace 




use "$DataPath\CH09\data_outmig_001020.dta",clear
sort share_00
gen rank_00=32-_n
sort share_10
gen rank_10=32-_n
sort share_20
gen rank_20=32-_n


twoway ///
  (scatter  rank_10 rank_00,mcolor(gs8) msize(medlarge) msymbol(Oh))    ///
  (scatter  rank_20 rank_10,mcolor(gs4) msize(medlarge) msymbol(O))    ///
  ( lfit    rank_10 rank_00,clwidth(med) lw(med) lpattern(dash) lcolor(gs8)) ///
  ( lfit    rank_20 rank_10,clwidth(medlarge) lw(med) lpattern(solid) lcolor(gs4)) ///
   ,  scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
ytitle("排序(10+20)", size(med))                                        ///
xtitle("2000年流出规模排序", size(med))               ///
xmtick(0(1)31)  xlabel(0(1)31, labsize(small) angle(15))   ///
ymtick(0(4)32) ylabel(0(4)32,labsize(med) angle(360))   ///
legend(order(  3  "2010年"  4 "2020年" )  row(1) size(small)) 


graph export "$DataPath\CH09\图_9_流出规模排序.png", replace width(1600)